-- ===========================================================================
-- Copyright (C) 2001-2005 Rodolphe Quiedeville <rodolphe@quiedeville.org>
-- Copyright (C) 2004-2012 Laurent Destailleur  <eldy@users.sourceforge.net>
-- Copyright (C) 2005-2012 Regis Houssin        <regis.houssin@inodbox.com>
-- Copyright (C) 2010      Juanjo Menent        <jmenent@2byte.es>
-- Copyright (C) 2012      Cédric Salvador      <csalvador@gpcsolutions.fr>
-- Copyright (C) 2014      Raphaël Doursenaud   <rdoursenaud@gpcsolutions.fr>
-- 
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program. If not, see <https://www.gnu.org/licenses/>.
--
-- ===========================================================================


create table llx_facture
(
  rowid					integer AUTO_INCREMENT PRIMARY KEY,

  ref					varchar(30)        NOT NULL,			-- invoice reference number
  entity				integer  DEFAULT 1 NOT NULL,			-- multi company id

  ref_ext				varchar(255),							-- reference into an external system (not used by dolibarr)
  ref_client			varchar(255),							-- reference for customer

  type					smallint DEFAULT 0 NOT NULL,			-- type of invoice
  fk_soc				integer            NOT NULL,
  datec					datetime,								-- date de creation de la facture
  datef					date,									-- date invoice
  date_pointoftax		date DEFAULT NULL,									-- date point of tax (for GB)
  date_valid			date,									-- date validation
  tms					timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,								-- last modification date
  date_closing				datetime,						-- date de cloture
  paye					smallint DEFAULT 0 NOT NULL,

  remise_percent		real     DEFAULT 0,						-- remise relative
  remise_absolue		real     DEFAULT 0,						-- remise absolue
  remise				real     DEFAULT 0,						-- remise totale calculee

  close_code			varchar(16),							-- Code motif cloture sans paiement complet
  close_missing_amount	double(24,8),							-- Amount missing when closing with a not complete payment
  close_note			varchar(128),							-- Commentaire cloture sans paiement complet

  total_tva				double(24,8)     DEFAULT 0,				-- amount total tva apres remise totale
  localtax1				double(24,8)     DEFAULT 0,				-- amount total localtax1
  localtax2				double(24,8)     DEFAULT 0,				-- amount total localtax2	
  revenuestamp          double(24,8)     DEFAULT 0,				-- amount total revenuestamp
  total_ht				double(24,8)     DEFAULT 0,				-- amount total ht apres remise totale
  total_ttc				double(24,8)     DEFAULT 0,				-- amount total ttc apres remise totale

  fk_statut				smallint DEFAULT 0 NOT NULL,

  fk_user_author		integer,								-- user making creation
  fk_user_modif         integer,                                -- user making last change
  fk_user_valid			integer,								-- user validating
  fk_user_closing			integer,						-- user closing
  
  module_source			varchar(32),							-- name of module when invoice generated by a dedicated module (POS, ...)
  pos_source			varchar(32),							-- numero of POS terminal when order is generated by a POS module, IDsession@IDwebsite when order is generated for a website basket.
  fk_fac_rec_source		integer,								-- facture rec source
  fk_facture_source		integer,								-- facture origin if credit notes or replacement invoice
  fk_projet				integer DEFAULT NULL,					-- project invoice is linked to
  increment				varchar(10),							-- Numero of generation if generated from recurring template invoice

  fk_account			integer,								-- bank account
  fk_currency			varchar(3),								-- currency code
  
  fk_cond_reglement		integer  DEFAULT 1 NOT NULL,			-- payment term (30 days, end of month...)
  fk_mode_reglement		integer,								-- payment mode (Virement, Prelevement)
  date_lim_reglement	date,									-- due date

  note_private			text,
  note_public			text,
  model_pdf				varchar(255),
  last_main_doc			varchar(255),					-- relative filepath+filename of last main generated document

  fk_incoterms          integer,								-- for incoterms
  location_incoterms    varchar(255),							-- for incoterms

  fk_transport_mode     integer,								-- for intracomm report

  situation_cycle_ref smallint,  -- situation cycle reference. A key that is similar for all the serie.
  situation_counter   smallint,  -- situation counter. The number into the serie: 1, 2, ...
  situation_final     smallint,  -- 0 by default, 1 it if is the final invoice.

  retained_warranty							real DEFAULT NULL,  -- % of retained warranty
  retained_warranty_date_limit				date DEFAULT NULL,
  retained_warranty_fk_cond_reglement		integer  DEFAULT NULL,			-- payment condition of retained warranty

  import_key			varchar(14),
  extraparams			varchar(255),							-- for other parameters with json format
  
  fk_multicurrency		integer,
  multicurrency_code			varchar(3),
  multicurrency_tx			double(24,8) DEFAULT 1,
  multicurrency_total_ht		double(24,8) DEFAULT 0,
  multicurrency_total_tva	double(24,8) DEFAULT 0,
  multicurrency_total_ttc	double(24,8) DEFAULT 0
)ENGINE=innodb;
